// // // // // // // // // // // // // // // //
//
//	FastAttack2 - DisplayedObject.cc
//
//	erstellt 5.1.98 von Andreas Warnke
//	geändert 9.1.98 von Andreas Warnke
//



#include "DisplayedObject.h"
#include "AsciiKette.h"



// // // // // // // // // // // // // // // //
//
//	Konstruktor:
//

DisplayedObject :: DisplayedObject ()
{
	//	Default-Werte
	Typ = Obj_NoObject;
	Name = NULL;
	BelongsTo = 0;
	XPos = -1;
	YPos = -1;
	BusyTill = real_time_clock_usecs();
};



// // // // // // // // // // // // // // // //
//
//	2. Konstruktor:
//

DisplayedObject :: DisplayedObject (
	unsigned int inID,
	unsigned int inType,
	const char * inName,
	unsigned int inOwner,
	int inX,
	int inY,
	bigtime_t inBusyTill )
{
	Typ = inType;
	if ( inName == NULL )
		Name = NULL;
	else
		Name = Concat ( inName, NULL );
	BelongsTo = inOwner;
	XPos = inX;
	YPos = inY;
	BusyTill = inBusyTill;
	ID = inID;
};



// // // // // // // // // // // // // // // //
//
//	copy-Konstruktor:
//

DisplayedObject :: DisplayedObject ( const DisplayedObject & inOriginal )
{
	//	Kopie:
	Typ = inOriginal . Typ;
	if ( Name != NULL )
	{
		delete [] Name;
		Name = NULL;
	};
	if ( inOriginal . Name != NULL )
		Name = Concat ( inOriginal . Name, NULL );
	BelongsTo = inOriginal . BelongsTo;
	XPos = inOriginal . XPos;
	YPos = inOriginal . YPos;
	BusyTill = inOriginal . BusyTill;
	ID = inOriginal . ID;
};



// // // // // // // // // // // // // // // //
//
//	Destruktor:
//

DisplayedObject :: ~DisplayedObject ()
{
	//	Ungültig-Werte
	Typ = Obj_NoObject;
	if ( Name != NULL )
	{
		delete [] Name;
		Name = NULL;
	};
	BelongsTo = 0;
	XPos = -1;
	YPos = -1;
	BusyTill = int64( 0x7fffffffffffffff );
	ID = 0;
};



//
//	Ende.
//
// // // // // // // // // // // // // // // //


